/* --COPYRIGHT--,BSD_EX
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 *
 *                       MSP430 CODE EXAMPLE DISCLAIMER
 *
 * MSP430 code examples are self-contained low-level programs that typically
 * demonstrate a single peripheral function or device feature in a highly
 * concise manner. For this the code may rely on the device's power-on default
 * register values and settings such as the clock configuration and care must
 * be taken when combining code from several examples to avoid potential side
 * effects. Also see www.ti.com/grace for a GUI- and www.ti.com/msp430ware
 * for an API functional library-approach to peripheral configuration.
 *
 * --/COPYRIGHT--*/
/*
 * Thermopile.h
 *
 *  Created on: May 25, 2020
 *      Author: JD Crutchfield
 */

#ifndef MSP430I2040_THERMOPILE_H_
#define MSP430I2040_THERMOPILE_H_

void InitTemperatureMeasurement(void);
//void ThermoAveraging(void);
unsigned long ThermoCompensation(void);

extern long   g_lSD24ThermopileBuffer[];
extern long   g_lSD24ThermistorBuffer[];
extern long   g_lSD24VrefBuffer[];
extern long   g_lThermopileResult;
extern long   g_lThermistorResult;


extern long   g_lSD24VrefResult;
extern long   g_lSD24VbattResult;

extern unsigned int g_uiSD24BufferPointer;       //miliseconds between samples.  10ms=100sps


extern long test_global;

//// used to tell LUT which way to lookup the output
#define FORWARD_LOOKUP  1
#define REVERSE_LOOKUP  0

#define CALIBRATION_THERMISTOR_OFFSET    0
#define CALIBRATION_THERMOPILE_OFFSET    0

//#define S_CONV_x100             100      // TESTING, NEEDS TO BE STORED IN FLASH
#define NTC_R1_DIVIDER_OHM      154000
#define VREF_VOLTAGE_mV         1650    // 1.65v from external
#define TC_SENS                 -.0045  // From datasheet for TS318-11C55
//#define TC_SENS                 -4.5    // From datasheet for TS318-11C55
#define TC_SENS_x10000          -45   // From datasheet for TS318-11C55

#define AMBIENT_TEMP_CAL_mC     25000   // Temp in milliCelsius at which LUT was calibrated.
#define LUT_LENGTH              51




#endif /* MSP430I2040_THERMOPILE_H_ */
